clc
clear all
close all

%% get the FOUs
[words,MFs]=getFOUs();
A=[0 0 5 5 0 0 5 5 1];
B=[5 5 10 10 5 5 10 10 1];

%% Plot the ordered interval type-2 word models
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
for i=1:32
    V(i)=VS(MFs(i,:),A);
    J(i)=Jaccard(MFs(i,:),A);
    V2(i)=VS(MFs(i,:),B);
    J2(i)=Jaccard(MFs(i,:),B);
    subplot(8,6,2*floor((i-1)/4)+i);
    plotIT2(MFs(i,:));
    plot([5 5],[0 1],'k--');
    title(words(i,:),'fontsize',8);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'Fig4-3.eps');

%%
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
subplot(321);
plot([0 0 5 5],[0 1 1 0],'k-','linewidth',2);
hold on
plot([5 5 10 10],[0 1 1 0],'k--','linewidth',2);
text('Interpreter','latex','String','$\tilde{B}$','Position',[2.5,1.06],'horizontalalignment','center','verticalalignment','bottom','fontsize',12);
text('Interpreter','latex','String','$\tilde{C}$','Position',[7.5,1.06],'horizontalalignment','center','verticalalignment','bottom','fontsize',12);
set(gca,'YTick',[]);
set(gca,'XTick',0:1:10);
set(gca,'YTick',[0 1]);
axis([0,10,0,1.4]);
saveas(gcf,'Fig4-4.eps');

format bank
[V' J']
[V2' J2']


